<?php
/**
 * Kalium WordPress Theme
 *
 * Divider widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

vc_map(
	[
		'base'        => 'lab_divider',
		'name'        => 'Divider',
		'description' => 'Text or plain divider',
		'category'    => 'Laborator',
		'icon'        => kalium()->file_url( 'includes/wpbakery/assets/images/divider.svg' ),
		'params'      => [
			[
				'type'        => 'dropdown',
				'heading'     => 'Type',
				'param_name'  => 'type',
				'admin_label' => true,
				'std'         => 'text',
				'value'       => [
					'Plain'        => 'plain',
					'Text Divider' => 'text',
				],
				'description' => 'Select the type of divider, plain or text divider.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Divider Style',
				'param_name'  => 'plain_style',
				'value'       => [
					'Saw Border' => 'saw',
					'Thin Dash'  => 'thin',
					'Thick Dash' => 'thick',
				],
				'description' => 'Select style of plain divider.',
				'dependency'  => [
					'element' => 'type',
					'value'   => [ 'plain' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Width',
				'param_name'  => 'plain_width',
				'description' => 'Divider width in percentage unit 1-100, leave empty to use 100 percent as value.',
				'dependency'  => [
					'element' => 'type',
					'value'   => [ 'plain' ],
				],
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Divider Style',
				'param_name'  => 'text_style',
				'value'       => [
					'Thick'         => '2',
					'Dotted'        => '5',
					'Striped'       => '6',
					'Double Border' => '3',
					'Shadowed'      => '1',
					'Inverse'       => '4',
					'Saw'           => '7',
				],
				'description' => 'Select style of text divider.',
				'dependency'  => [
					'element' => 'type',
					'value'   => [ 'text' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Title',
				'param_name'  => 'title',
				'admin_label' => true,
				'description' => 'Divider title to display in the center.',
				'dependency'  => [
					'element' => 'type',
					'value'   => [ 'text' ],
				],
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Color',
				'param_name'  => 'plain_color',
				'description' => 'Set custom border color, leave empty to use default.',
				'dependency'  => [
					'element' => 'plain_style',
					'value'   => [ 'thin', 'thick' ],
				],
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Color',
				'param_name'  => 'text_color',
				'description' => 'Set custom border color, leave empty to use default.',
				'dependency'  => [
					'element' => 'text_style',
					'value'   => [ '1', '2', '3', '4' ],
				],
			],
			[
				'type'        => 'colorpicker',
				'heading'     => 'Text Color',
				'param_name'  => 'text_color_font',
				'description' => 'Set custom text color, leave empty to use default.',
				'dependency'  => [
					'element' => 'type',
					'value'   => [ 'text' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Divider extends WPBakeryShortCode {}
