<?php
/**
 * Kalium WordPress Theme
 *
 * Post item template.
 *
 * @var array $classes
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<li id="post-<?php the_ID(); ?>" <?php post_class( 'post' ); ?>>

	<article class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
		
		<?php
			/**
			 * kalium_blog_loop_post_before hook
			 *
			 * @hooked kalium_blog_post_thumbnail - 10
			 */
			do_action( 'kalium_blog_loop_post_before' );
		?>
		
		<div <?php kalium_class_attr( [ 'post-details' ] ); ?>>
			
			<?php
				/**
				 * kalium_blog_loop_post_details hook
				 *
				 * @hooked kalium_blog_post_title - 10
				 * @hooked kalium_blog_post_excerpt - 20
				 * @hooked kalium_blog_post_date - 30
				 * @hooked kalium_blog_post_category - 40
				 */
				do_action( 'kalium_blog_loop_post_details' );
			?>
			
		</div>
		
		<?php
			/**
			 * kalium_blog_loop_post_after hook
			 *
			 * @hooked none
			 */
			do_action( 'kalium_blog_loop_post_after' );
		?>
		
	</article>
	
</li>
