<?php
/**
 * Kalium WordPress Theme
 *
 * Post thumbnail hover overlay.
 *
 * @var array $classes
 * @var string $hover_icon
 * @var string $hover_icon_custom
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div <?php kalium_class_attr( $classes ); ?>>
	
	<?php
	// Simple icon
	if ( 'static-eye' === $hover_icon ) {
		printf( '<span class="hover-icon basic"><i class="%s"></i></span>', esc_attr( apply_filters( 'kalium_blog_loop_hover_icon', 'kalium-icon-eye' ) ) );
	}
		// Animated eye icon
	elseif ( 'animated-eye' === $hover_icon ) {
		echo '<span class="hover-icon animated-eye"></span>';
	}
		// Custom icon
	elseif ( 'custom' === $hover_icon ) {
		printf( '<span class="hover-icon custom">%s</span>', $hover_icon_custom );
	}
	?>
	
</div>
