<?php
/**
 * Kalium WordPress Theme
 *
 * Portfolio items.
 *
 * @var string $id
 * @var array $classes
 * @var WP_Query $the_query
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<ul id="<?php echo esc_attr( $id ); ?>" <?php kalium_class_attr( $classes ); ?>>

	<?php
	/**
	 * Portfolio items loop.
	 */
	if ( $the_query->have_posts() ) :

		while ( $the_query->have_posts() ) :
			$the_query->the_post();

			?>
			<li <?php post_class( 'portfolio-item-entry' ); ?>>

				<?php
				/**
				 * Item template.
				 */
				kalium_portfolio_loop_item_template();
				?>

			</li>
			<?php

		endwhile;

	else :

		/**
		 * Hook: kalium_portfolio_no_posts_found.
		 */
		do_action( 'kalium_portfolio_no_posts_found' );

	endif;
	?>

</ul>
