<?php
/**
 * Kalium WordPress Theme
 *
 * Portfolio item featured image.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 *
 * @var int $attachment_id
 * @var string $image_size
 *
 * @version 4.0.4
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="portfolio-item__thumbnail">

	<?php
	/**
	 * Before thumbnail hook.
	 */
	do_action( 'kalium_portfolio_loop_before_thumbnail' );
	?>

	<a href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr( get_the_title() ); ?>">

		<?php
		/**
		 * Display featured image.
		 */
		echo kalium_get_attachment_image( $attachment_id, $image_size, kalium_get_featured_image_attrs() );
		?>

	</a>

	<?php
	/**
	 * After thumbnail hook.
	 */
	do_action( 'kalium_portfolio_loop_after_thumbnail' );
	?>
	
</div>
