<?php
/**
 * Kalium WordPress Theme
 *
 * Item type template.
 *
 * @var string $item_type
 * @var array $container_attributes
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

array_unshift( $container_attributes['class'], 'single-portfolio__type' );

if ( $layout = kalium_get_portfolio_single_item_type_option( 'layout' ) ) {
	$container_attributes['class'][] = 'single-portfolio__type--' . $layout;
}

?>
<div <?php kalium_attributes( $container_attributes ); ?>>

	<div class="single-portfolio__content">
		<?php
		/**
		 * Hook: kalium_portfolio_single_{$item_type}_content
		 */
		do_action( "kalium_portfolio_single_{$item_type}_content", $item_type );
		?>
	</div>

	<div class="single-portfolio__gallery-container">
		<?php
		/**
		 * Hook: kalium_portfolio_single_{$item_type}_gallery
		 */
		do_action( "kalium_portfolio_single_{$item_type}_gallery", $item_type );
		?>
	</div>

</div>
