<?php
/**
 * Kalium WordPress Theme
 *
 * Title and subtitle.
 *
 * @var array $classes
 * @var string $tag_name
 * @var string $title
 * @var string $subtitle
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div <?php kalium_class_attr( $classes ); ?>>
	<?php
	// Title
	kalium_element(
		[
			'tag_name' => $tag_name,
			'content'  => $title,
			'echo'     => true,
		]
	);

	// Subtitle
	if ( ! empty( $subtitle ) ) {
		kalium_element(
			[
				'tag_name'   => 'div',
				'attributes' => [
					'class' => 'single-portfolio__title__subtitle',
				],
				'content'    => $subtitle,
				'echo'       => true,
			]
		);
	}
	?>
</div>
