<?php
/**
 * Kalium WordPress Theme
 *
 * Search results info.
 *
 * @var int $found_posts
 * @var string $search_input
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="search-results-info">
	<h1>
		<?php printf( esc_html( _n( '%1$d result for “%2$s”', '%1$d results for “%2$s”', $found_posts, 'kalium' ) ), $found_posts, $search_input ); ?>
	</h1>

	<?php if ( $found_posts ) : ?>
		<p><?php printf( _n( 'We have found one match with the word you searched.', 'We have found %d results with the word you searched.', $found_posts, 'kalium' ), $found_posts ); ?></p>
	<?php else : ?>
		<p><?php _e( 'There is nothing found that matches your search criteria.', 'kalium' ); ?></p>
	<?php endif; ?>
</div>
