<?php
/**
 * Kalium WordPress Theme
 *
 * Add to cart link.
 *
 * @var array $args
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $product;

// Loading indicator
$loading_indicator = '<span class="link-button__loading"></span>';

// Link content
$content = [];

// Show icon
if ( $args['show_icon'] ) {
	$icon = sprintf( '<i class="%s"></i>', $args['icon'] );

	// Custom icon
	if ( ! empty( $args['icon_custom'] ) ) {
		$icon = $args['icon_custom'];
	}

	$content[] = sprintf( '<span class="link-button__content link-button__content--icon"><span class="button-icon">%s</span>%s</span>', $icon, $loading_indicator );
} else {
	$content[] = $loading_indicator;
}

// Show text
if ( $args['show_text'] ) {
	$content[] = sprintf( '<span class="link-button__content link-button__content--text">%s</span>', esc_html( $product->add_to_cart_text() ) );
}

echo apply_filters(
	'woocommerce_loop_add_to_cart_link',
	sprintf(
		'<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
		esc_url( $product->add_to_cart_url() ),
		esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
		esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
		isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
		implode( '', $content )
	),
	$product,
	$args
);
