<?php
/**
 * Kalium WordPress Theme
 *
 * Mini cart popup used in header.
 *
 * @var bool $is_empty
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="cart-items">
	<?php
	if ( $is_empty ) :
		?>
		<div class="empty-loading-cart-contents">
			<i class="kalium-icon-shopping-bag-empty"></i>
			<p><?php kalium_xtranslate( 'esc_html_e', 'Your cart is currently empty!', 'woocommerce' ); ?></p>
			<a href="<?php echo esc_url( wc_get_page_permalink( 'shop' ) ); ?>" class="button button-size-small button-outline"><?php kalium_xtranslate( 'esc_html_e', 'Browse products', 'woocommerce' ); ?></a>
		</div>
		<?php
	endif;

	foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
		$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
		$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

		if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
			$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
			$price             = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );


			?>
			<div class="cart-item">
				<div class="product-image">
					<?php
					$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

					if ( ! $product_permalink ) {
						echo $thumbnail; // PHPCS: XSS ok.
					} else {
						printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
					}
					?>
				</div>
				<div class="product-details">

					<div <?php kalium_class_attr( [ 'product-name', kalium_get_link_plain_class() ] ); ?>>
						<?php
						if ( ! $_product->is_visible() ) {
							echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) . '&nbsp;' );
						} else {
							echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
						}
						?>
					</div>

					<span class="mc-quantity">
						<?php printf( '%s: %d &times; %s', kalium_xtranslate( 'esc_html__', 'Quantity', 'woocommerce' ), $cart_item['quantity'], $price ); ?>
					</span>

					<?php
					/**
					 * Hooks after product quantity is shown
					 *
					 * @arg $cart_item      Current cart item
					 * @arg $cart_item_key  Current cart item key
					 * @arg $_product       Product instance
					 */
					do_action( 'kalium_woocommerce_mini_cart_after_quantity', $cart_item, $cart_item_key, $_product );
					?>
				</div>
				<div class="product-subtotal">
					<?php
					echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
					?>
				</div>
			</div>
			<?php
		}
	}
	?>
</div>

<?php if ( ! $is_empty ) : ?>
<div class="cart-action-buttons">
	<div class="cart-subtotal">
		<?php kalium_xtranslate( 'esc_html_e', 'Subtotal', 'woocommerce' ); ?>:
		<?php wc_cart_totals_subtotal_html(); ?>
	</div>

		<div class="mc-buttons-container">
			<div class="go-to-cart">
				<a href="<?php echo wc_get_cart_url(); ?>" class="button button-block button-outline"><?php kalium_xtranslate( 'esc_html_e', 'View cart', 'woocommerce' ); ?></a>
			</div>

			<div class="go-to-checkout">
				<a href="<?php echo wc_get_checkout_url(); ?>" class="button button-block"><?php kalium_xtranslate( 'esc_html_e', 'Checkout', 'woocommerce' ); ?></a>
			</div>
		</div>
</div>
<?php endif; ?>
