<?php
/**
 * Kalium WordPress Theme
 *
 * Dribbble shots widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Dribbble shots
$shots = WPBakeryShortCode_Lab_Dribbble_Gallery::get_user_shots( $atts );

if ( is_array( $shots ) && $count > 0 && count( $shots ) > $count ) {
	$shots = array_slice( $shots, 0, $count );
}

// More link
$more_link = vc_build_link( $more_link );

// Element Class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'lab-dribbble-shots',
	'dribbble-shots',
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

$list_classes = array_merge(
	[
		'grid',
	],
	kalium_responsive_classname_infix(
		[
			'desktop' => kalium_get_number_from_word( $columns ),
			'tablet'  => ceil( kalium_get_number_from_word( $columns ) / 2 ),
			'mobile'  => 1,
		],
		'columns'
	)
);

?>
<div <?php kalium_class_attr( $classes ); ?>>
	<?php
	if ( is_array( $shots ) ) :

		?>
		<div <?php kalium_class_attr( $list_classes ); ?>>

			<?php
			foreach ( $shots as $shot ) :
				$html_url = $shot->html_url;
				$title    = $shot->title;
				$image    = $shot->images->normal;

				if ( ! empty( $shot->images->hidpi ) ) {
					$image = $shot->images->hidpi;
				}

				if ( ! empty( $shot->images->two_x ) ) {
					$image = $shot->images->two_x;
				}

				$image = kalium()->images->get_image(
					sprintf(
						'<img src="%s" alt="%s" width="400" height="300">',
						esc_url( $image ),
						esc_html( $title )
					)
				);

				?>
				<div class="dribbble-shots__shot">
					<a href="<?php echo esc_html( $html_url ); ?>" target="_blank" rel="noopener"><?php echo $image; ?></a>
					<h3 class="dribbble-shots__shot__title <?php echo kalium_get_link_style_class(); ?>">
						<a href="<?php echo esc_url( $html_url ); ?>" target="_blank" rel="noopener"><?php echo esc_html( $title ); ?></a>
					</h3>
				</div>
				<?php
			endforeach;
			?>

		</div>
		<?php

		if ( $more_link['title'] && $more_link['url'] ) :
			kalium_load_more_link( $more_link );
		endif;

	elseif ( is_wp_error( $shots ) ) :

		?>
		<div class="dribbble-shots__errors">
			<?php
			echo $shots->get_error_message();
			?>
		</div>
		<?php

	endif;
	?>
</div>
