<?php
/**
 * Kalium WordPress Theme
 *
 * Member entry.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $parent_attrs;

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

if ( strpos( $description, '#E-' ) !== false ) {
	$description = vc_value_from_safe( $description );
	$description = nl2br( $description );
}

// Element Class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

// If no image return empty
if ( ! $image ) {
	return;
}

$thumb_size = $parent_attrs['img_size'];

$link = vc_build_link( $link );

// Fix the issue with {space}_blank target
if ( isset( $link['target'] ) ) {
	$link['target'] = trim( $link['target'] );
}

// Image size
if ( ! empty( $thumb_size ) && strpos( $thumb_size, 'x' ) !== false ) {
	$thumb_size = explode( 'x', $thumb_size );
}

// Rel attribute
$rel_attr = kalium_conditional( '_blank' === $link['target'], ' rel="noopener"' );

$visible_titles = 'visible-titles' === $parent_attrs['layout_type'];

$member_attrs = array_merge(
	[
		'class' => [
			'member',
			'layout-' . $parent_attrs['layout_type'],
			$css_class,
		],
	],
	kalium_animate_on_viewport( kalium_parse_legacy_wow_args( $parent_attrs['reveal_effect'] ) )
);

$hover_layer_attrs = [
	'class' => [
		'hover-state',
		'padding',
		kalium_conditional( 'distanced' === $parent_attrs['hover_style'], 'with-spacing' ),
	],
];

if ( ! empty( $link['url'] ) ) {
	$hover_layer_attrs = array_merge(
		$hover_layer_attrs,
		[
			'data-href'   => $link['url'],
			'data-target' => $link['target'],
		]
	);
}

// Member details
ob_start();

?>
	<div <?php kalium_class_attr( [ 'member-details', kalium_get_link_plain_class() ] ); ?>>
		<h2>
			<?php if ( $link['url'] ) : ?>
				<a href="<?php echo esc_url( $link['url'] ); ?>" target="<?php echo esc_attr( $link['target'] ); ?>"<?php echo $rel_attr; ?> title="<?php echo esc_attr( $link['title'] ); ?>"><?php echo esc_html( $name ); ?></a>
			<?php else : ?>
				<?php echo esc_html( $name ); ?>
			<?php endif; ?>
		</h2>
		<?php if ( $sub_title ) : ?>
			<p class="job-title"><?php echo esc_html( $sub_title ); ?></p>
		<?php endif; ?>
	</div>
<?php

$member_details = ob_get_clean();

?>
<div <?php kalium_class_attr( $parent_attrs['item_class'] ); ?>>
	<div <?php kalium_attributes( $member_attrs ); ?>>
		<div class="thumb">
			<?php if ( $parent_attrs['hover_style'] !== 'none' && ( $visible_titles && $description || ! $visible_titles ) ) : ?>
				<div <?php kalium_attributes( $hover_layer_attrs ); ?>>
					<?php if ( $description ) : ?>
						<div <?php kalium_class_attr( [ 'social', kalium_get_link_style_class_by_context( 'team-member-social' ) ] ); ?>>
							<?php echo $description; ?>
						</div>
					<?php endif; ?>

					<?php if ( ! $visible_titles ) : ?>
						<?php echo $member_details; ?>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<?php if ( $link['url'] ) : ?>
				<a href="<?php echo esc_url( $link['url'] ); ?>" target="<?php echo esc_attr( $link['target'] ); ?>"<?php echo $rel_attr; ?> title="<?php echo esc_attr( $link['title'] ); ?>">
					<?php echo kalium_get_attachment_image( $image, $thumb_size ); ?>
				</a>
			<?php else : ?>
				<?php echo kalium_get_attachment_image( $image, $thumb_size ); ?>
			<?php endif; ?>
		</div>

		<?php if ( $visible_titles ) : ?>
			<?php echo $member_details; ?>
		<?php endif; ?>
	</div>
</div>
