<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( isset( $GLOBALS['svx'] ) && 0 === version_compare( $GLOBALS['svx'], '1.7.3' ) ) :

	if ( ! class_exists( 'SevenVXGet' ) ) {

		class SevenVXGet {

			public static $version = '1.7.3';

			protected static $_instance = null;

			public static $settings = array();

			public static $version_checked = array();

			public static function instance() {
				if ( is_null( self::$_instance ) ) {
					self::$_instance = new self();
				}
				return self::$_instance;
			}

			function __construct() {

			}

			public function get_option_autoload( $option, $default = null ) {
				if ( isset( self::$settings['autoload'] ) ) {
					if ( isset( self::$settings['autoload'][ $option ] ) ) {
						return self::$settings['autoload'][ $option ];
					}

					if ( null !== $default ) {
						return $default;
					}

					return false;
				}

				$options = get_option( 'svx_autoload', false );

				if ( false !== $options ) {
					self::$settings['autoload'] = $options;
					
					if ( isset( $options[ $option ] ) ) {
						return $options[ $option ];
					}
				}

				if ( null !== $default ) {
					return $default;
				}
				return false;
			}

			public function get_option( $option, $plugin, $default = null ) {
				if ( isset( self::$settings[ $plugin ] ) ) {
					if ( isset( self::$settings[ $plugin ][ $option ] ) ) {
						if ( empty( self::$settings[ $plugin ][ $option ] ) && gettype( self::$settings[ $plugin ][ $option ] ) !== gettype( $default ) ) {
							return $default;
						} else {
							return self::$settings[ $plugin ][ $option ];
						}
					}

					if ( null !== $default ) {
						return $default;
					}

					return false;
				}

				$options = get_option( 'svx_settings_' . $plugin, false );

				if ( false !== $options ) {
					self::$settings[ $plugin ] = $options;

					if ( isset( self::$settings[ $plugin ][ $option ] ) ) {
						if ( empty( self::$settings[ $plugin ][ $option ] ) && gettype( self::$settings[ $plugin ][ $option ] ) !== gettype( $default ) ) {
							return $default;
						} else {
							return self::$settings[ $plugin ][ $option ];
						}
					}
				}

				if ( null !== $default ) {
					return $default;
				}

				return false;
			}

			public function esc_color( $color ) {
				if ( empty( $color ) || is_array( $color ) ) {
					return 'rgba(0,0,0,0.0625)';
				}
	
				if ( false === strpos( $color, 'rgba' ) ) {
					return sanitize_hex_color( $color );
				}
	
				$color = str_replace( ' ', '', $color );

				sscanf( $color, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha );

				return 'rgba(' . $red . ',' . $green . ',' . $blue . ',' . $alpha . ')';
			}

			public function version_check( $version = '3.0.0' ) {
				if ( isset( self::$version_checked[ $version ] ) ) {
					return self::$version_checked[ $version ];
				}

				global $woocommerce;

				if ( version_compare( $woocommerce->version, $version, '>=' ) ) {
					self::$version_checked[ $version ] = true;

					return true;
				}

				self::$version_checked[ $version ] = false;

				return false;
			}

			public function plugin_page_check( $plugin ) {
				global $pagenow;
				
				if ( 'admin.php' === $pagenow && isset( $_GET['page'], $_GET['tab'] ) && 'wc-settings' === $_GET['page'] && $plugin === $_GET['tab'] ) {
					return true;
				}

				return false;
			}

			public function xforwoo_page_check() {
				global $pagenow;
				
				if ( 'admin.php' === $pagenow && isset( $_GET['page'] ) && 'xforwoocommerce' === $_GET['page'] ) {
					return true;
				}

				return false;
			}
			
		}

		function SevenVXGet() {
			return SevenVXGet::instance();
		}

		SevenVXGet::instance();

	}

endif;
