<?php

/**
 * assign a tag to the size guide post
 * @author aries
 */
class ctSizeGuideProducts {

	/**
	 * Inits object
	 */

	public function __construct() {
		add_action( 'add_meta_boxes', array( $this, 'chooseProducts' ) );
		add_action( 'save_post_ct_size_guide', array( $this, 'saveSizeGuideProducts' ) );
	}

	/**
	 * Register metabox
	 */

	public function chooseProducts() {
		add_meta_box( 'ct_sizeguideopt_products', __( 'Choose products', 'ct-sgp' ), array(
			$this,
			'renderSizeGuideProducts'
		), 'ct_size_guide', 'side' );
	}



	/**
	 * Render categoriers
	 *
	 * @param $post
	 */

	public function renderSizeGuideProducts( $post ) {
        $sizeGuideId = $post->ID;
		$args = [
            "post_type" => "product",
            "posts_per_page" => -1,
        ];
        $productsQuery = new WP_Query($args);
        if (!$productsQuery->have_posts()) {
            return;
        }
        
		$assignedProducts = $this->getSelectedProducts($sizeGuideId);
        if (!isset($assignedProducts) || !is_array($assignedProducts)) {
            $assignedProducts = [];
        }
        ctSizeGuideAdmin::appendSearch();

        echo '<div class="ct-sgp-checkboxes">';
		foreach ( $productsQuery->posts as $product ) {
            if (!$product instanceof WP_Post) {
                continue;
            }
			$checked = false;
			if ( is_array($assignedProducts) && in_array( $product->ID, $assignedProducts ) ) {
				$checked = ' checked';
			}
			echo '<div class="ct-sgp-checkbox">';
            echo '<input class="ct-sgp-checkbox__input" type="checkbox" name="ct_sg_prods[]" value="' . esc_attr($product->ID) . '"' . $checked . ' />';
            echo '<span class="ct-sgp-checkbox__name">'. sanitize_text_field($product->post_title) . '</span>';
			echo '</div>';

		}
        echo '</div>';

	}

    public function getSelectedProducts($sizeGuideId) {
        if (!is_numeric($sizeGuideId)) {
            return [];
        }
        $queryArgs = [
            'post_type' => 'product',
            "posts_per_page" => -1,
            "fields" => "ids",
            "meta_query" => [
                [
                    "key" => "_ct_selectsizeguide",
                    "value" => $sizeGuideId
                ]

            ]
        ];
        $query = new WP_Query($queryArgs);
        if (!$query->have_posts()) {
            return [];
        }
        return $query->posts;

    }
	/**
	 * Save categories
	 *
	 * @param $sizeGuideId
	 */

	public function saveSizeGuideProducts( $sizeGuideId ) {
        if (!is_numeric($sizeGuideId)) {
            return;
        }
		
        $oldSelectedProducts = $this->getSelectedProducts($sizeGuideId);
        foreach ($oldSelectedProducts as $productId) {
            if (!is_numeric($productId)) {
                continue;
            }
            delete_post_meta($productId, '_ct_selectsizeguide');
        }

        $selectedProducts = (isset($_POST['ct_sg_prods']) && is_array($_POST['ct_sg_prods'])) ? $_POST['ct_sg_prods'] : [];
        if (!count($selectedProducts) > 0) {
            return;
        }

        foreach ($selectedProducts as $productId) {
            if (!is_numeric($productId)) {
                continue;
            }
            update_post_meta($productId, '_ct_selectsizeguide', $sizeGuideId);
        }
    }

}

new ctSizeGuideProducts();