<?php
/**
 * Kalium WordPress Theme
 *
 * Not found page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Theme header.
 */
get_header();

?>
<div class="container">
	<div class="not-found">
		<div class="not-found__box">
			<div class="not-found__404">
				<span class="flashing-num">4</span>
				<span class="flashing-num del-1">0</span>
				<span class="flashing-num del-2">4</span>
			</div>
		</div>
		<h1 class="not-found__title"><?php esc_html_e( 'Not found!', 'kalium' ); ?></h1>
		<p><?php printf( __( 'We’re sorry, the page you have looked for does not exist in our database! <br /> Perhaps you would like to go to our <a href="%s">home page</a>?', 'kalium' ), home_url() ); ?></p>
	</div>
</div>
<?php

/**
 * Theme footer.
 */
get_footer();
