<?php
/**
 * Kalium WordPress Theme
 *
 * Comments template.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Container classes
$container_classes = [
	'container',
	kalium_conditional( kalium_is_narrow_blog_layout(), 'container-narrow' ),
];

// Comments list
if ( have_comments() ) :
	$comments_number  = get_comments_number();
	$comments_classes = [
		'comments-list',
	];

	if ( ! get_option( 'show_avatars' ) ) {
		$comments_classes[] = 'comments-list--no-avatars';
	}
	?>
	<section id="comments" class="post-comments">
		<div <?php kalium_class_attr( $container_classes ); ?>>
			<div class="post-comments__section-title">
				<h2><?php printf( _n( '1 Comment', '%d Comments', $comments_number, 'kalium' ), $comments_number ); ?></h2>
				<p><?php $comments_number > 0 ? esc_html_e( 'Join the discussion and tell us your opinion.', 'kalium' ) : esc_html_e( 'Be the first to comment on this article.', 'kalium' ); ?></p>
			</div>

			<ul <?php kalium_class_attr( $comments_classes ); ?>>
				<?php
				// Comments List
				wp_list_comments(
					[
						'callback'     => 'kalium_blog_post_comment',
						'end-callback' => 'kalium_blog_post_comment_end',
					]
				);
				?>
			</ul>

			<?php
				// Comments pagination
				kalium_comments_pagination();
			?>
		</div>

	</section>
	<?php

endif;

// Post comment form
if ( comments_open() ) :
	?>
	<section class="post-comment-form">
		<div <?php kalium_class_attr( $container_classes ); ?>>
			<?php
			comment_form(
				[
					'format'               => 'html5',
					'title_reply'          => have_comments() ? esc_html__( 'Leave a reply', 'kalium' ) : esc_html__( 'Share your thoughts', 'kalium' ),
					'title_reply_to'       => esc_html__( 'Reply to %s', 'kalium' ),
					'comment_notes_before' => '',
					'comment_notes_after'  => '',
					'label_submit'         => esc_html__( 'Comment', 'kalium' ),
					'class_submit'         => 'button',
				]
			);
			?>
		</div>
	</section>
	<?php
endif;
