<?php
/**
 * Kalium WordPress Theme
 *
 * Theme header.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}
?><!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php
// WP body open
wp_body_open();

/**
 * Before wrapper hooks.
 *
 * @hooked kalium_site_frame_display - 10
 * @hooked kalium_mobile_menu_display - 20
 * @hooked kalium_mobile_menu_close_button_display - 21
 * @hooked kalium_header_off_canvas_top_menu_display - 30
 * @hooked kalium_header_off_canvas_side_menu_display - 40
 */
do_action( 'kalium_before_wrapper' );

/**
 * Wrapper start hooks.
 *
 * @hooked kalium_site_wrapper_start - 0
 * @hooked kalium_header_display - 10
 * @hooked kalium_page_heading_title_display - 20
 */
do_action( 'kalium_wrapper_start' );
