<?php
/**
 * Kalium WordPress Theme
 *
 * Plugins install page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Multisite warning for non network administrators
if ( is_multisite() && ! current_user_can( 'install_plugins' ) ) :
	?>
	<div class="kalium-dashboard__plugins-multisite-notice">
		<strong>Warning:</strong>
		<?php
		echo kalium_conditional(
			current_user_can( 'activate_plugins' ),
			'Only network administrators can install and update plugins.',
			'Only network administrators can install, update and activate plugins.'
		);
		?>
	</div>
	<?php
endif;

/**
 * List theme plugins.
 */
kalium()->theme_plugins->list_theme_plugins();
