<?php
/**
 * Kalium WordPress Theme
 *
 * About tabs.
 *
 * @var array $tabs
 * @var string $page
 * @var string $current_tab
 * @var string $latest_version
 * @var bool $is_latest_version
 * @var string $account_link
 * @var string $changelog_link
 * @var string $update_core_link
 * @var string $plan_name
 * @var int $support_status_code
 * @var string $support_expire_text
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */

use Kalium\Admin\Dashboard;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<nav class="kalium-dashboard__header-navigation">
	<a href="<?php echo esc_url( 'admin.php?page=kalium' ); ?>" class="nav-logo">
		<i class="kalium-admin-icon-kalium"></i>
	</a>

	<?php
	foreach ( $tabs as $tab_id => $tab ) :
		$classes = [
			'nav-item',
		];

		if ( isset( $tab['tab_item'] ) && false === $tab['tab_item'] ) {
			continue;
		}

		// Active tab class
		if ( $tab_id === $current_tab ) {
			$classes[] = 'nav-item-active';
		}

		?>
		<a href="<?php echo Dashboard::tab_link( $tab_id ); ?>" <?php kalium_class_attr( $classes ); ?>><?php echo esc_html( $tab['name'] ); ?></a>
		<?php

	endforeach;
	?>

	<?php if ( Dashboard::maybe_show_section( 'nav-plan-title' ) ) : ?>
		<a href="<?php echo esc_url( $account_link ); ?>" class="license-info license-info--support-<?php echo esc_attr( $support_status_code ); ?>" title="<?php echo esc_attr( $support_expire_text ); ?>">
			<?php echo esc_html( $plan_name ); ?>
			<?php if ( kalium()->license->is_trial() ) : ?>
				<span class="badge">Trial</span>
			<?php endif; ?>
		</a>
	<?php endif; ?>

	<?php if ( Dashboard::maybe_show_section( 'nav-version-info' ) ) : ?>
		<?php if ( $is_latest_version ) : ?>
			<a href="<?php echo esc_url( $changelog_link ); ?>" class="nav-version"><?php echo esc_html( kalium()->get_version() ); ?></a>
		<?php else : ?>
			<a href="<?php echo esc_url( $update_core_link ); ?>" class="nav-version nav-version-alt" title="New update available (<?php echo esc_attr( $latest_version ); ?>)">
				<i class="kalium-admin-icon-refresh"></i>
				<?php echo esc_html( kalium()->get_version() ); ?>
			</a>
		<?php endif; ?>
	<?php endif; ?>
</nav>
