<?php
/**
 * Kalium WordPress Theme
 *
 * Admin tooltips.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Admin;

class Tooltips {

	/**
	 * Adds tooltip attributes to HTML element.
	 *
	 * @param string $content
	 * @param array  $args
	 *
	 * @return array|null
	 */
	public static function tooltip( $content, $args = [] ) {
		$args = wp_parse_args(
			$args,
			[
				'trigger'    => null,
				'placement'  => null,
				'echo'       => true,
				'echo_space' => true,
			]
		);

		$atts = [];

		if ( ! empty( $content ) ) {
			$atts['data-tippy-content'] = trim( $content );

			foreach ( [ 'trigger', 'placement' ] as $attr ) {
				if ( isset( $args[ $attr ] ) ) {
					$atts[ "data-tippy-$attr" ] = $args[ $attr ];
				}
			}
		}

		if ( $args['echo'] ) {
			echo $args['echo_space'] ? ' ' : '';
			echo kalium()->helpers->list_attributes( $atts );
			return;
		}

		return $atts;
	}
}
