<?php
/**
 * Kalium WordPress Theme
 *
 * WPML compatibility class.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Compatibility;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}
class WPML {

	/**
	 * Construct.
	 */
	public function __construct() {
		if ( ! kalium()->is->wpml_active() ) {
			return;
		}

		// Update translation preferences
		add_action( 'wp_ajax_kalium_update_wpml_cf_preferences', [ $this, 'update_wpml_cf_preferences' ] );
	}

	/**
	 * Update translation preferences for local fields.
	 *
	 * @since 4.1.3
	 */
	public function update_wpml_cf_preferences() {
		if ( ! current_user_can( 'manage_options' ) || ! class_exists( 'WPML_ACF' ) ) {
			return;
		}

		$cft_preferences = & $GLOBALS['iclTranslationManagement']->settings['custom_fields_translation'];

		foreach ( acf_get_local_fields() as $field ) {
			$field_name = $field['name'] ?? null;

			if ( empty( $field_name ) ) {
				continue;
			}

			// Set translation preference for field key reference
			$cft_preferences[ '_' . $field_name ] = 1;

			// Trigger update for the field
			acf_update_field( $field );
		}

		wp_send_json_success();
	}
}
