<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Border Box Control.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Border_Box extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-border-box';

	/**
	 * Border style.
	 *
	 * @var bool
	 */
	public $border_style = false;

	/**
	 * Color picker.
	 *
	 * @var bool
	 */
	public $color_picker = true;

	/**
	 * Enable alpha.
	 *
	 * @var bool
	 */
	public $enable_alpha = true;

	/**
	 * Show base colors palette.
	 *
	 * @var bool
	 */
	public $base_colors = true;

	/**
	 * Disable units.
	 *
	 * @var bool
	 */
	public $disable_units = false;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['border_style']  = $this->border_style;
		$this->json['enable_alpha']  = $this->enable_alpha;
		$this->json['color_picker']  = $this->color_picker;
		$this->json['disable_units'] = $this->disable_units;
		$this->json['base_colors']   = $this->base_colors;
	}
}
