<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Custom Select.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Custom_Select extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-custom-select';

	/**
	 * Multiple.
	 *
	 * @var bool
	 */
	public $multiple;

	/**
	 * Size.
	 *
	 * @var int
	 */
	public $size;

	/**
	 * Prefix.
	 *
	 * @var string
	 */
	public $prefix;

	/**
	 * Suffix.
	 *
	 * @var string
	 */
	public $suffix;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['multiple'] = $this->multiple;
		$this->json['size']     = $this->size;
		$this->json['prefix']   = $this->prefix;
		$this->json['suffix']   = $this->suffix;
	}
}
