<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: HTML.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class HTML extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-html';

	/**
	 * Contextual.
	 *
	 * @var bool
	 */
	public $contextual = true;

	/**
	 * HTML Content.
	 *
	 * @var string
	 */
	public $html;

	/**
	 * HTML content.
	 */
	public function content_template() {
		?>
		<div class="<?php echo esc_attr( $this->control_class_name ); ?>__html">
			{{{ data.html }}}
		</div>
		<?php
	}

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['html'] = $this->html;
	}
}
