<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Image.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Media extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-media';

	/**
	 * Select label.
	 *
	 * @var string
	 */
	public $select_label;

	/**
	 * Library params.
	 *
	 * @var array
	 */
	public $library_params = [];

	/**
	 * Background size.
	 *
	 * @var string
	 */
	public $background_size;

	/**
	 * Height.
	 *
	 * @var string|number
	 */
	public $height;

	/**
	 * Preview image size.
	 *
	 * @var string
	 */
	public $preview_size = 'medium';

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['select_label']    = $this->select_label;
		$this->json['library_params']  = $this->library_params;
		$this->json['background_size'] = $this->background_size;
		$this->json['height']          = $this->height;
		$this->json['preview_size']    = $this->preview_size;
	}
}
