<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Multi Numeric.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Multi_Numeric extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-multi-numeric';

	/**
	 * Value props.
	 *
	 * @var array
	 */
	public $value_props = [
		'top'    => 'Top',
		'right'  => 'Right',
		'bottom' => 'Bottom',
		'left'   => 'Left',
	];

	/**
	 * Link values.
	 *
	 * @var bool
	 */
	public $link_values = true;

	/**
	 * Units.
	 *
	 * @var array
	 */
	public $units;

	/**
	 * Placeholder.
	 *
	 * @var array
	 */
	public $placeholder;

	/**
	 * Min.
	 *
	 * @var int|float
	 */
	public $min;

	/**
	 * Max.
	 *
	 * @var int|float
	 */
	public $max;

	/**
	 * Step.
	 *
	 * @var int|float
	 */
	public $step;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['value_props'] = $this->value_props;
		$this->json['link_values'] = $this->link_values;
		$this->json['units']       = $this->units;
		$this->json['placeholder'] = $this->placeholder;
		$this->json['min']         = $this->min;
		$this->json['max']         = $this->max;
		$this->json['step']        = $this->step;
	}
}
