<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Options Export.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Options_Export extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-options-export';

	/**
	 * Contextual.
	 *
	 * @var bool
	 */
	public $contextual = true;

	/**
	 * Button text.
	 *
	 * @var string
	 */
	public $button_text;

	/**
	 * Transfer mode.
	 *
	 * @var string
	 */
	public $transfer_mode;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$button_text = $this->button_text;
		$transfer_mode = $this->transfer_mode;

		if ( $transfer_mode ) {
			$button_text = 'child' === $transfer_mode ? 'Copy from Child Theme' : 'Copy from Parent Theme';
		}

		$this->json['button_text'] = $button_text;
		$this->json['transfer_mode'] = $transfer_mode;
	}
}
