<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Select.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Select extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-select';

	/**
	 * Multiple.
	 *
	 * @var bool
	 */
	public $multiple;

	/**
	 * Size.
	 *
	 * @var int
	 */
	public $size;

	/**
	 * Prefix.
	 *
	 * @var string
	 */
	public $prefix;

	/**
	 * Suffix.
	 *
	 * @var string
	 */
	public $suffix;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['multiple'] = $this->multiple;
		$this->json['size']     = $this->size;
		$this->json['prefix']   = $this->prefix;
		$this->json['suffix']   = $this->suffix;
	}
}
