<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Text.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Text extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-text';

	/**
	 * Input type.
	 *
	 * @var string
	 */
	public $input_type = 'text';

	/**
	 * Placeholder.
	 *
	 * @var string
	 */
	public $placeholder;

	/**
	 * Step.
	 *
	 * @var int
	 */
	public $step;

	/**
	 * Min.
	 *
	 * @var int
	 */
	public $min;

	/**
	 * Max.
	 *
	 * @var int
	 */
	public $max;

	/**
	 * Prefix.
	 *
	 * @var string
	 */
	public $prefix;

	/**
	 * Suffix.
	 *
	 * @var string
	 */
	public $suffix;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['input_type']  = $this->input_type;
		$this->json['placeholder'] = $this->placeholder;
		$this->json['step']        = $this->step;
		$this->json['min']         = $this->min;
		$this->json['max']         = $this->max;
		$this->json['prefix']      = $this->prefix;
		$this->json['suffix']      = $this->suffix;
	}
}
