<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Search Section.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Section_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Search_Section extends Base_Section {

	/**
	 * Section type.
	 *
	 * @var string
	 */
	public $type = 'kalium-search';

	/**
	 * No results text.
	 *
	 * @var string
	 */
	public $no_results_text;

	/**
	 * Max results.
	 *
	 * @var int
	 */
	public $max_results;

	/**
	 * To JSON.
	 *
	 * @return array
	 */
	public function json() {
		return array_merge(
			parent::json(),
			[
				'no_results_text' => $this->no_results_text,
				'max_results'     => $this->max_results,
			]
		);
	}
}
