<?php
/**
 * Kalium WordPress Theme
 *
 * Native media handler.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Media\Handlers;

use Kalium\Media\Media_Handler;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Native extends Media_Handler {

	/**
	 * Handler name.
	 *
	 * @var string
	 */
	public $handler_name = 'kalium-native';

	/**
	 * Prepare audio attributes.
	 *
	 * @param array $out
	 * @param array $pairs
	 * @param array $atts
	 *
	 * @return array
	 */
	public function prepare_atts_audio( $out, $pairs, $atts ) {
		if ( ! empty( $atts['poster'] ) ) {
			$out = wp_parse_args(
				$atts,
				wp_parse_args(
					$out,
					[
						'width'  => 170,
						'height' => 70,
						'poster' => null,
					]
				)
			);

		} else {
			// Native audio class
			$out['wrapper_class'][] = 'audio--native';
		}

		return parent::prepare_atts_audio( $out, $pairs, $atts );
	}

	/**
	 * Video parser.
	 *
	 * @param string $output
	 * @param array  $atts
	 * @param string $video
	 * @param int    $post_id
	 * @param string $library
	 *
	 * @return string
	 */
	public function parse_video( $output, $atts, $video, $post_id, $library ) {
		$source = kalium()->media->extract_media_source( $output );

		if ( kalium()->media->is_youtube( $source ) ) {
			return kalium()->media->embed_youtube( $source, $atts );
		} elseif ( kalium()->media->is_vimeo( $source ) ) {
			return kalium()->media->embed_vimeo( $source, $atts );
		}

		return parent::parse_audio( $output, $atts, $video, $post_id, $library );
	}

	/**
	 * Audio parser.
	 *
	 * @param string $output
	 * @param array  $atts
	 * @param string $audio
	 * @param int    $post_id
	 * @param string $library
	 *
	 * @return string
	 */
	public function parse_audio( $output, $atts, $audio, $post_id, $library ) {
		if ( ! empty( $atts['poster'] ) ) {
			$output = sprintf(
				'<img src="%s" class="native-audio-poster" alt="" width="%d" height="%d" />%s',
				$atts['poster'],
				$atts['width'],
				$atts['height'],
				$output
			);
		}

		return $output;
	}
}
