<?php
/**
 * Kalium WordPress Theme
 *
 * VideoJS media handler.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Media\Handlers;

use Kalium\Media\Media_Handler;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class VideoJS extends Media_Handler {

	/**
	 * Handler name.
	 *
	 * @var string
	 */
	public $handler_name = 'kalium-videojs';

	/**
	 * Constructor.
	 */
	public function init() {
		parent::init();

		// VideoJS skin
		$this->handler_options['skin'] = kalium_get_theme_option( 'videojs_player_skin' );

		// Use default YouTube player
		$this->handler_options['useDefaultYouTubePlayer'] = kalium_get_theme_option( 'videojs_youtube_player' );

		// Library load strategy [viewport, pageload]
		$this->handler_options['libraryLoadStrategy'] = 'viewport';
	}

	/**
	 * Video parser.
	 *
	 * @param string $output
	 * @param array  $atts
	 * @param string $video
	 * @param int    $post_id
	 * @param string $library
	 *
	 * @return string
	 */
	public function parse_video( $output, $atts, $video, $post_id, $library ) {
		$source = kalium()->media->extract_media_source( $output );

		// YouTube player
		if ( kalium()->media->is_youtube( $source ) && $this->handler_options['useDefaultYouTubePlayer'] ) {
			kalium_enqueue( 'youtube-player-api' );

			return kalium()->media->embed_youtube( $source, $atts );
		}
		// Vimeo player
		elseif ( kalium()->media->is_vimeo( $source ) ) {
			kalium_enqueue( 'vimeo-player-api' );

			return kalium()->media->embed_vimeo( $source, $atts );
		}

		// Enqueue VideoJS library
		kalium_enqueue( 'videojs' );

		// YouTube tech for VideoJS
		if ( kalium()->media->is_youtube( $source ) ) {
			kalium_enqueue( 'videojs-youtube' );
		}

		return $output;
	}

	/**
	 * Audio parser.
	 *
	 * @param string $output
	 * @param array  $atts
	 * @param string $audio
	 * @param int    $post_id
	 * @param string $library
	 *
	 * @return string
	 */
	public function parse_audio( $output, $atts, $audio, $post_id, $library ) {
		kalium_enqueue( 'videojs' );

		// Poster
		if ( ! empty( $atts['poster'] ) ) {
			$output = kalium()->helpers->add_element_attribute( $output, 'audio', 'poster', $atts['poster'] );
		} else {
			$output = kalium()->helpers->add_element_attribute( $output, 'audio', 'data-videojs-audio' );
		}

		return $output;
	}
}
