<?php
/**
 * Kalium WordPress Theme
 *
 * Page template functions.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'kalium_page_content_wrapper_start' ) ) {

	/**
	 * Page content wrapper start.
	 */
	function kalium_page_content_wrapper_start() {
		kalium_content_wrapper_start(
			'page',
			[
				'container_fullwidth' => true,
			]
		);
	}
}

if ( ! function_exists( 'kalium_page_content_wrapper_end' ) ) {

	/**
	 * Page content wrapper start.
	 */
	function kalium_page_content_wrapper_end() {
		kalium_content_wrapper_end( 'page' );
	}
}

if ( ! function_exists( 'kalium_page_heading_title_display' ) ) {

	/**
	 * Page heading title display.
	 */
	function kalium_page_heading_title_display() {
		if ( ! kalium()->page->show_page_heading() || kalium_is_maintenance_mode() ) {
			return;
		}

		kalium_page_heading(
			[
				'heading_tag' => kalium()->page->get_page_heading( 'tag' ),
				'title'       => kalium()->page->get_page_heading( 'title' ),
				'description' => kalium()->page->get_page_heading( 'description' ),
			]
		);
	}
}
