<?php
/**
 * Kalium WordPress Theme
 *
 * Slider Revolution field type.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */

if ( ! class_exists( 'acf_field' ) ) {
	return;
}

class acf_field_revsliders extends acf_field {

	/**
	 * Construct.
	 */
	function __construct() {
		$this->name     = 'revsliders';
		$this->label    = 'Revolution Sliders';
		$this->category = 'Choice';
		$this->defaults = [
			'default_value' => '',
		];

		parent::__construct();
	}

	/**
	 * Create field.
	 *
	 * @param array $field
	 */
	function create_field( $field ) {
		if ( class_exists( 'RevSlider' ) ) {
			$slider  = new RevSlider();
			$sliders = $slider->getArrSlidersShort();
		} else {
			$sliders = [
				'(Slider Revolution plugin not active)',
			];
		}

		// vars
		$o = [ 'id', 'class', 'name', 'value' ];
		$e = '';

		$e .= '<div class="acf-revsliders">';
		$e .= '<select';

		foreach ( $o as $k ) {
			$e .= ' ' . $k . '="' . esc_attr( $field[ $k ] ) . '"';
		}

		$e .= '>';

		foreach ( $sliders as $slider_id => $slider_name ) {
			$e .= '<option value="' . $slider_id . '" ' . selected( $slider_id, $field['value'], false ) . '>' . $slider_name . '</option>';
		}

		$e .= '</select>';
		$e .= '</div>';

		echo $e;
	}

	/**
	 * Render field.
	 *
	 * @param array $field
	 */
	function render_field( $field ) {
		$this->create_field( $field );
	}
}

new acf_field_revsliders();
