<?php
/**
 * Kalium WordPress Theme
 *
 * Starter Site Type - Ninja Forms class.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Importer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Import_Ninja_Forms extends Import_Type {

	/**
	 * Get content pack name.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'Forms';
	}

	/**
	 * Import forms.
	 *
	 * @return void
	 */
	public function do_import() {
		parent::do_import();

		// Do not run if there are errors reported or option is unchecked
		if ( $this->errors->has_errors() || ! $this->is_checked() ) {
			return;
		}

		// Vars
		$content_pack    = $this->get_content_pack();
		$import_manager  = $content_pack->import_manager();
		$backup_manager  = $content_pack->backup_manager();
		$import_instance = $content_pack->get_import_instance();

		$ninja_forms = [];

		// Loop through each source
		foreach ( $this->get_sources() as $source ) {
			$forms_file = $import_manager->get_content_pack_import_source_path( $source['name'] );

			// Check if form file exists
			if ( kalium()->filesystem->exists( $forms_file ) ) {
				$existing_id   = preg_replace( '/^.*?(\d+)\.nff$/', '$1', $forms_file );
				$ninja_forms[] = Ninja_Forms()->form()->import_form( file_get_contents( $forms_file ), false, $existing_id );

				// Mark as successful import
				$import_instance->set_import_success();
			} else {

				// Slider file doesn't exists
				$this->errors->add( 'kalium_importer_ninja_forms_not_exists', 'Ninja Forms file doesn\'t exists!' );
			}
		}

		// Set imported forms
		if ( ! empty( $ninja_forms ) ) {
			$backup_manager->update_backup_option( 'ninja_forms', $ninja_forms, true, true );
		}

		// Add errors to import instance
		if ( $this->errors->has_errors() ) {
			$import_instance->add_error( $this->errors );
		}
	}

	/**
	 * Remove imported forms.
	 *
	 * @return void
	 */
	public function do_remove() {
		if ( ! $this->plugins_are_active() ) {
			$this->errors->add( 'kalium_importer_remove_plugins_not_active', sprintf( 'Required plugins are not active, <strong>%s</strong> cannot be uninstalled.', $this->get_name() ) );
			return;
		}

		$backup_manager = $this->get_content_pack()->backup_manager();
		$ninja_forms    = $backup_manager->get_backup_option( 'ninja_forms' );

		if ( is_array( $ninja_forms ) ) {
			foreach ( $ninja_forms as $form_id ) {
				Ninja_Forms()->form( $form_id )->delete();
			}
		}

		// Mark as removed
		parent::do_remove();
	}
}
