<?php
/**
 * Content Type definition.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$disabled_message_text = 'plugin should be installed and activated in order for this element to work.';

return [
	// Elements
	'elements'        => [
		'legacy_header_content_left'                => [
			'extend' => [
				'element' => 'legacy_header_row',
				'title'   => 'Left Content',
			],
		],
		'legacy_header_content_right'               => [
			'extend' => [
				'element'           => 'legacy_header_row',
				'title'             => 'Right Content',
				'extend_attributes' => [
					'align' => [
						'default' => 'right',
					],
				],
			],
		],
		'legacy_header_menu'                        => [
			'extend' => [
				'extend_attributes' => [
					'menu_item_spacing' => [
						'initial_position' => 10,
						'placeholder'      => 10,
					],
				],
			],
		],
		'legacy_header_raw_text',
		'legacy_header_search_field',
		'legacy_header_social_icons',
		'legacy_header_button',
		'legacy_header_date_time',
		'legacy_header_woocommerce_my_account_link' => [
			'extend' => [
				'enabled'          => kalium()->is->woocommerce_active(),
				'disabled_message' => 'WooCommerce ' . $disabled_message_text,
			],
		],
		'legacy_header_woocommerce_cart_totals'     => [
			'extend' => [
				'enabled'          => kalium()->is->woocommerce_active(),
				'disabled_message' => 'WooCommerce ' . $disabled_message_text,
			],
		],
		'legacy_header_wpml_language_switcher'      => [
			'extend' => [
				'enabled'          => kalium()->is->wpml_active(),
				'disabled_message' => 'WPML ' . $disabled_message_text,
			],
		],
		'legacy_header_breadcrumb'                  => [
			'extend' => [
				'enabled'          => kalium()->is->breadcrumb_navxt_active(),
				'disabled_message' => 'Breadcrumb NavXT ' . $disabled_message_text,
			],
		],
	],

	// Regions
	'regions'         => [
		'legacy_header_content_left',
		'legacy_header_content_right',
	],

	// Show attributes on Add Element
	'show_attributes' => true,
];
