<?php
/**
 * Content Type definition.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$social_icon_element = 'social_icon';

return [
	// Elements
	'elements'        => apply_filters(
		'kalium_social_icons_elements',
		[
			'kalium_social_icon_apple_podcasts' => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Apple Podcasts',
					'icon'              => 'kalium-social-icon-applepodcasts',
					'extend_attributes' => [
						'color' => [
							'default' => '#9933CC',
						],
					],
				],
			],
			'kalium_social_icon_behance'        => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Behance',
					'icon'              => 'kalium-social-icon-behance',
					'extend_attributes' => [
						'color' => [
							'default' => '#1769ff',
						],
					],
				],
			],
			'kalium_social_icon_bluesky'        => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Bluesky',
					'icon'              => 'kalium-social-icon-bluesky',
					'extend_attributes' => [
						'color' => [
							'default' => '#0085ff',
						],
					],
				],
			],
			'kalium_social_icon_deviant_art'    => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'DeviantArt',
					'icon'              => 'kalium-social-icon-deviantart',
					'extend_attributes' => [
						'color' => [
							'default' => '#05cc47',
						],
					],
				],
			],
			'kalium_social_icon_discord'        => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Discord',
					'icon'              => 'kalium-social-icon-discord',
					'extend_attributes' => [
						'color' => [
							'default' => '#5865f2',
						],
					],
				],
			],
			'kalium_social_icon_dribbble'       => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Dribbble',
					'icon'              => 'kalium-social-icon-dribbble',
					'extend_attributes' => [
						'color' => [
							'default' => '#ea4c89',
						],
					],
				],
			],
			'kalium_social_icon_email'          => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Email',
					'icon'              => 'kalium-social-icon-email',
					'extend_attributes' => [
						'link'  => [
							'title'       => 'Email',
							'placeholder' => 'someone@email.com',
						],
						'color' => [
							'default' => '#ea4335',
						],
					],
					'supports_blank'    => false,
				],
			],
			'kalium_social_icon_facebook'       => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Facebook',
					'icon'              => 'kalium-social-icon-facebook',
					'extend_attributes' => [
						'color' => [
							'default' => '#1877f2',
						],
					],
				],
			],
			'kalium_social_icon_messenger'      => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Messenger',
					'icon'              => 'kalium-social-icon-messenger',
					'extend_attributes' => [
						'color' => [
							'default' => '#00B2FF',
						],
					],
				],
			],
			'kalium_social_icon_flickr'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Flickr',
					'icon'              => 'kalium-social-icon-flickr',
					'extend_attributes' => [
						'color' => [
							'default' => '#0063dc',
						],
					],
				],
			],
			'kalium_social_icon_foursquare'     => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Foursquare',
					'icon'              => 'kalium-social-icon-foursquare',
					'extend_attributes' => [
						'color' => [
							'default' => '#f94877',
						],
					],
				],
			],
			'kalium_social_icon_github'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'GitHub',
					'icon'              => 'kalium-social-icon-github',
					'extend_attributes' => [
						'color' => [
							'default' => '#181717',
						],
					],
				],
			],
			'kalium_social_icon_houzz'          => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Houzz',
					'icon'              => 'kalium-social-icon-houzz',
					'extend_attributes' => [
						'color' => [
							'default' => '#7ac142',
						],
					],
				],
			],
			'kalium_social_icon_instagram'      => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Instagram',
					'icon'              => 'kalium-social-icon-instagram',
					'extend_attributes' => [
						'color' => [
							'default' => '#e4405f',
						],
					],
				],
			],
			'kalium_social_icon_linkedin'       => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'LinkedIn',
					'icon'              => 'kalium-social-icon-linkedin',
					'extend_attributes' => [
						'color' => [
							'default' => '#0077b5',
						],
					],
				],
			],
			'kalium_social_icon_mastodon'       => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Mastodon',
					'icon'              => 'kalium-social-icon-mastodon',
					'extend_attributes' => [
						'color' => [
							'default' => '#6364FF',
						],
					],
				],
			],
			'kalium_social_icon_medium'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Medium',
					'icon'              => 'kalium-social-icon-medium',
					'extend_attributes' => [
						'color' => [
							'default' => '#000000',
						],
					],
				],
			],
			'kalium_social_icon_phone'          => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Phone',
					'icon'              => 'kalium-social-icon-phone-alt',
					'extend_attributes' => [
						'link' => [
							'title'       => 'Phone',
							'placeholder' => '+1 (000) 000-0000',
						],
					],
				],
			],
			'kalium_social_icon_pinterest'      => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Pinterest',
					'icon'              => 'kalium-social-icon-pinterest',
					'extend_attributes' => [
						'color' => [
							'default' => '#e60023',
						],
					],
				],
			],
			'kalium_social_icon_500px'          => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => '500px',
					'icon'              => 'kalium-social-icon-px',
					'extend_attributes' => [
						'color' => [
							'default' => '#0099e5',
						],
					],
				],
			],
			'kalium_social_icon_reddit'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Reddit',
					'icon'              => 'kalium-social-icon-reddit',
					'extend_attributes' => [
						'color' => [
							'default' => '#ff4500',
						],
					],
				],
			],
			'kalium_social_icon_rss'            => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'RSS',
					'icon'              => 'kalium-social-icon-rss',
					'extend_attributes' => [
						'color' => [
							'default' => '#f26522',
						],
					],
				],
			],
			'kalium_social_icon_skype'          => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Skype',
					'icon'              => 'kalium-social-icon-skype',
					'extend_attributes' => [
						'color' => [
							'default' => '#00aff0',
						],
					],
				],
			],
			'kalium_social_icon_snapchat'       => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Snapchat',
					'icon'              => 'kalium-social-icon-snapchat',
					'extend_attributes' => [
						'color' => [
							'default' => '#fffc00',
						],
					],
				],
			],
			'kalium_social_icon_soundcloud'     => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'SoundCloud',
					'icon'              => 'kalium-social-icon-soundcloud',
					'extend_attributes' => [
						'color' => [
							'default' => '#ff8800',
						],
					],
				],
			],
			'kalium_social_icon_spotify'        => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Spotify',
					'icon'              => 'kalium-social-icon-spotify',
					'extend_attributes' => [
						'color' => [
							'default' => '#1db954',
						],
					],
				],
			],
			'kalium_social_icon_telegram'       => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Telegram',
					'icon'              => 'kalium-social-icon-telegram',
					'extend_attributes' => [
						'color' => [
							'default' => '#0088cc',
						],
					],
				],
			],
			'kalium_social_icon_threads'        => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Threads',
					'icon'              => 'kalium-social-icon-threads',
					'extend_attributes' => [
						'color' => [
							'default' => '#000000',
						],
					],
				],
			],
			'kalium_social_icon_tiktok'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'TikTok',
					'icon'              => 'kalium-social-icon-tiktok',
					'extend_attributes' => [
						'color' => [
							'default' => '#000000',
						],
					],
				],
			],
			'kalium_social_icon_tripadvisor'    => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'TripAdvisor',
					'icon'              => 'kalium-social-icon-tripadvisor',
					'extend_attributes' => [
						'color' => [
							'default' => '#00af87',
						],
					],
				],
			],
			'kalium_social_icon_tumblr'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Tumblr',
					'icon'              => 'kalium-social-icon-tumblr',
					'extend_attributes' => [
						'color' => [
							'default' => '#35465c',
						],
					],
				],
			],
			'kalium_social_icon_twitch'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Twitch',
					'icon'              => 'kalium-social-icon-twitch',
					'extend_attributes' => [
						'color' => [
							'default' => '#9146ff',
						],
					],
				],
			],
			'kalium_social_icon_twitter_x'      => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Twitter X',
					'icon'              => 'kalium-social-icon-twitter-x',
					'extend_attributes' => [
						'color' => [
							'default' => '#000000',
						],
					],
				],
			],
			'kalium_social_icon_twitter'        => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Twitter',
					'icon'              => 'kalium-social-icon-twitter',
					'extend_attributes' => [
						'color' => [
							'default' => '#1da1f2',
						],
					],
				],
			],
			'kalium_social_icon_vimeo'          => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Vimeo',
					'icon'              => 'kalium-social-icon-vimeo',
					'extend_attributes' => [
						'color' => [
							'default' => '#1ab7ea',
						],
					],
				],
			],
			'kalium_social_icon_vkontakte'      => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'VKontakte',
					'icon'              => 'kalium-social-icon-vk',
					'extend_attributes' => [
						'color' => [
							'default' => '#45668e',
						],
					],
				],
			],
			'kalium_social_icon_whatsapp'       => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'WhatsApp',
					'icon'              => 'kalium-social-icon-whatsapp',
					'extend_attributes' => [
						'color' => [
							'default' => '#25D366',
						],
					],
				],
			],
			'kalium_social_icon_wechat'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'WeChat',
					'icon'              => 'kalium-social-icon-wechat',
					'extend_attributes' => [
						'color' => [
							'default' => '#07C160',
						],
					],
				],
			],
			'kalium_social_icon_xing'           => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Xing',
					'icon'              => 'kalium-social-icon-xing',
					'extend_attributes' => [
						'color' => [
							'default' => '#026466',
						],
					],
				],
			],
			'kalium_social_icon_yelp'           => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Yelp',
					'icon'              => 'kalium-social-icon-yelp',
					'extend_attributes' => [
						'color' => [
							'default' => '#af0606',
						],
					],
				],
			],
			'kalium_social_icon_youtube'        => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'YouTube',
					'icon'              => 'kalium-social-icon-youtube',
					'extend_attributes' => [
						'color' => [
							'default' => '#ff0000',
						],
					],
				],
			],
			'kalium_social_icon_web'            => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Web',
					'icon'              => 'kalium-social-icon-web',
					'extend_attributes' => [
						'color' => [
							'default' => '#000000',
						],
					],
				],
			],
			'kalium_social_icon_custom'         => [
				'extend' => [
					'element'           => $social_icon_element,
					'title'             => 'Custom Icon',
					'icon'              => 'kalium-social-icon-custom',
					'extend_attributes' => [
						'icon_type'        => [
							'type'    => 'radio',
							'title'   => 'Custom Icon',
							'choices' => [
								'image'       => 'Upload Icon',
								'inline-html' => 'Inline HTML',
							],
							'buttons' => true,
						],
						'icon_image'       => [
							'type'         => 'media',
							'title'        => 'Icon',
							'library'      => [
								'type' => 'image',
							],
							'upload_label' => 'Choose From Library',
							'aspect_ratio' => '2.5:1',
							'dependency'   => [
								'icon_type' => 'image',
							],
						],
						'icon_inline_html' => [
							'type'        => 'textarea',
							'title'       => 'Inline HTML',
							'rows'        => 4,
							'monospace'   => true,
							'dependency'  => [
								'icon_type' => 'inline-html',
							],
							'description' => 'You can also add SVG code',
						],
					],
				],
			],
		]
	),

	// Visibility feature
	'visibility'      => false,

	// Display element icon
	'element_icon'    => true,

	// Show attributes on Add Element
	'show_attributes' => true,

	// Empty label
	'empty_label'     => 'Click to add Social Icons',

	// Search
	'search'          => 10,

	// Default content
	'default_content' => [
		[
			'name'       => 'kalium_social_icon_facebook',
			'attributes' => [
				[
					'name'  => 'link',
					'value' => '#facebook',
				],
			],
		],
		[
			'name'       => 'kalium_social_icon_instagram',
			'attributes' => [
				[
					'name'  => 'link',
					'value' => '#instagram',
				],
			],
		],
		[
			'name'       => 'kalium_social_icon_twitter',
			'attributes' => [
				[
					'name'  => 'link',
					'value' => '#twitter',
				],
			],
		],
	],
];
