<?php
/**
 * Content Type definition.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$social_share_link_element = [
	'element' => 'social_share_link',
];

return [
	// Elements
	'elements'        => [
		'social_share_link_facebook'  => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Facebook',
					'icon'  => 'kalium-social-icon-facebook',
				]
			),
		],
		'social_share_link_twitter'   => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Twitter X',
					'icon'  => 'kalium-social-icon-twitter-x',
				]
			),
		],
		'social_share_link_bluesky'   => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Bluesky',
					'icon'  => 'kalium-social-icon-bluesky',
				]
			),
		],
		'social_share_link_threads'   => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Threads',
					'icon'  => 'kalium-social-icon-threads',
				]
			),
		],
		'social_share_link_linkedin'  => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'LinkedIn',
					'icon'  => 'kalium-social-icon-linkedin',
				]
			),
		],
		'social_share_link_tumblr'    => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Tumblr',
					'icon'  => 'kalium-social-icon-tumblr',
				]
			),
		],
		'social_share_link_pinterest' => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Pinterest',
					'icon'  => 'kalium-social-icon-pinterest',
				]
			),
		],
		'social_share_link_email'     => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Email',
					'icon'  => 'kalium-social-icon-email',
				]
			),
		],
		'social_share_link_vkontakte' => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'VKontakte',
					'icon'  => 'kalium-social-icon-vk',
				]
			),
		],
		'social_share_link_whatsapp'  => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'WhatsApp',
					'icon'  => 'kalium-social-icon-whatsapp',
				]
			),
		],
		'social_share_link_telegram'  => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Telegram',
					'icon'  => 'kalium-social-icon-telegram',
				]
			),
		],
		'social_share_link_print'     => [
			'extend' => array_merge(
				$social_share_link_element,
				[
					'title' => 'Print',
					'icon'  => 'kalium-social-icon-print',
				]
			),
		],
	],

	// Visibility feature
	'visibility'      => false,

	// Display element icon
	'element_icon'    => true,

	// Empty label
	'empty_label'     => 'Click to add Share Networks',

	// Default content
	'default_content' => [
		[ 'name' => 'social_share_link_facebook' ],
		[ 'name' => 'social_share_link_twitter' ],
		[ 'name' => 'social_share_link_pinterest' ],
		[ 'name' => 'social_share_link_email' ],
	],
];
