<?php
/**
 * Column element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Sets\Content_Flex_Alignment_Set;
use Laborator_Builder\Attribute_Sets\Content_Visibility_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;
use Laborator_Builder\Element;

class Column extends Element {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'column';

	/**
	 * Title.
	 *
	 * @var string
	 */
	public static $title = 'Column';

	/**
	 * Icon.
	 *
	 * @var string
	 */
	public static $icon = 'columns';

	/**
	 * Child container.
	 *
	 * @var bool
	 */
	public static $child_container = true;

	/**
	 * Allowed child elements.
	 *
	 * @var bool
	 */
	public static $allowed_child_elements = [
		'!column',
	];

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Content_Visibility_Set::class,
				Content_Flex_Alignment_Set::class,
				Advanced_Layout_Set::class,
				Advanced_Border_Set::class,
				Advanced_Text_Set::class,
				Advanced_Dimensions_Set::class,
				Advanced_Custom_CSS_Set::class,
			]
		);
	}

	/**
	 * Attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'columns',
							[
								'type'         => 'select',
								'title'        => 'Width',
								'inline_label' => true,
								'responsive'   => true,
								'reset'        => true,
								'input_style'  => 'max-width:65%',
								'choices'      => [
									[
										'value' => 'default',
										'label' => 'Auto',
									],
									[
										'value' => 'auto',
										'label' => 'Content Fit',
									],
									[
										'value' => 1,
										'label' => '1 column - 1/12',
									],
									[
										'value' => 2,
										'label' => '2 columns - 1/6',
									],
									[
										'value' => 3,
										'label' => '3 columns - 1/4',
									],
									[
										'value' => 4,
										'label' => '4 columns - 1/3',
									],
									[
										'value' => 5,
										'label' => '5 columns - 5/12',
									],
									[
										'value' => 6,
										'label' => '6 columns - 1/2',
									],
									[
										'value' => 7,
										'label' => '7 columns - 7/12',
									],
									[
										'value' => 8,
										'label' => '8 columns - 2/3',
									],
									[
										'value' => 9,
										'label' => '9 columns - 3/4',
									],
									[
										'value' => 10,
										'label' => '10 columns - 5/6',
									],
									[
										'value' => 11,
										'label' => '11 columns - 11/12',
									],
									[
										'value' => 12,
										'label' => '12 columns - 1/1',
									],
									[
										'value' => 'w-20',
										'label' => '20% - 1/5',
									],
									[
										'value' => 'w-40',
										'label' => '40% - 2/5',
									],
									[
										'value' => 'w-60',
										'label' => '60% - 3/5',
									],
									[
										'value' => 'w-80',
										'label' => '80% - 4/5',
									],
								],
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		$classes = [
			'col',
		];

		// Columns
		$columns = kalium_responsive_classname_infix(
			array_map(
				function ( $value ) {
					if ( 'default' === $value ) {
						return 'auto-grow';
					}

					return $value;
				},
				$this->get_attribute_value( 'columns' )
			),
			'col'
		);

		if ( ! empty( $columns ) ) {
			$classes = array_merge( $classes, $columns );
		}

		return array_merge( parent::get_dom_class(), $classes );
	}
}

// Register element
\Laborator_Builder::register_element_type( Column::class );
