<?php
/**
 * Container row element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Container_Row extends Row {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'container_row';

	/**
	 * Attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::TAB_CONTENT,
					[
						Attribute::create(
							'gutter_x',
							[
								'type'             => 'range',
								'title'            => 'Horizontal Gap',
								'responsive'       => true,
								'reset'            => true,
								'min'              => 0,
								'slider_max'       => 100,
								'initial_position' => 24,
								'placeholder'      => 24,
								'units'            => kalium_get_default_units( 'length' ),
							]
						),
						Attribute::create(
							'gutter_y',
							[
								'type'             => 'range',
								'title'            => 'Vertical Gap',
								'responsive'       => true,
								'reset'            => true,
								'min'              => 0,
								'slider_max'       => 100,
								'initial_position' => 0,
								'placeholder'      => 0,
								'units'            => kalium_get_default_units( 'length' ),
							]
						),
					]
				),

				// Content / Container
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					'Container',
					[
						Attribute::create(
							'fullwidth',
							[
								'type'         => 'toggle',
								'title'        => 'Full Width',
								'inline_label' => true,
							]
						),
					]
				),

				// Style / Colors
				Attribute::tab_section(
					Attribute::TAB_STYLE,
					'Colors',
					[
						Attribute::create(
							'text_color',
							[
								'type'         => 'color',
								'title'        => 'Text',
								'inline_label' => true,
								'separator'    => false,
								'reset'        => true,
							]
						),
						Attribute::create(
							'headings_color',
							[
								'type'         => 'color',
								'title'        => 'Headings',
								'inline_label' => true,
								'separator'    => false,
								'reset'        => true,
							]
						),
						Attribute::create(
							'link_color',
							[
								'type'         => 'color',
								'title'        => 'Links',
								'inline_label' => true,
								'separator'    => false,
								'reset'        => true,
								'choices'      => [
									'normal' => 'Normal',
									'hover'  => 'Hover',
								],
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element start.
	 */
	public function element_start() {

		// Container row wrapper start
		parent::element_start();

		// Container wrapper start
		$container_class = $this->get_attribute_value( 'fullwidth' ) ? 'container-full' : 'container';

		printf( '<div class="%s">', esc_attr( $container_class ) );

		// Row wrapper start
		echo '<div ' . kalium_class_attr( $this->get_row_classes(), false ) . '>';
	}

	/**
	 * Element end.
	 */
	public function element_end() {
		// Row wrapper end
		echo '</div>';

		// Container wrapper end
		echo '</div>';

		// Container row wrapper end
		parent::element_end();
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {
		parent::generate_styles();

		$link_color_var       = kalium_css_var_name( 'link-color' );
		$link_hover_color_var = kalium_css_var_name( 'link-hover-color' );

		// Link color
		$link_color  = $this->get_attribute_value( 'link_color' );
		$link_normal = $link_color['normal'] ?? null;
		$link_hover  = $link_color['hover'] ?? null;

		$this->add_style(
			[
				'&'     => [
					// Text color
					'color'               => $this->get_attribute( 'text_color' ),

					// Headings
					kalium_css_var_name( 'footer-headings' ) => $this->get_attribute( 'headings_color' ),

					// Links
					$link_color_var       => $link_normal,
					$link_hover_color_var => $link_hover,
				],

				'.row'  => [
					kalium_css_var_name( 'gutter-x' ) => $this->get_attribute( 'gutter_x' ),
					kalium_css_var_name( 'gutter-y' ) => $this->get_attribute( 'gutter_y' ),
				],

				'.menu' => [
					$link_color_var       => $link_normal,
					$link_hover_color_var => $link_hover,
				],
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Container_Row::class );
