<?php
/**
 * Breadcrumb element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Breadcrumb extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_breadcrumb';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Breadcrumb';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'next';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'separator',
							[
								'type'        => 'text',
								'title'       => 'Separator',
								'placeholder' => '»',
								'description' => 'Placed in between each breadcrumb.',
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		static $index_counter = 1;

		// When Breadcrumb NavXT is activated
		if ( kalium()->is->breadcrumb_navxt_active() ) {
			$separator = $this->get_attribute_value( 'separator' );

			// Class
			$breadcrumb_id    = 'breadcrumb-' . $index_counter;
			$breadcrumb_class = $breadcrumb_id . ' all-links ' . kalium_get_link_style_class_by_context( 'header-breadcrumb', kalium_get_link_plain_class() );

			if ( $separator ) {
				kalium_append_custom_css(
					'.breadcrumb.' . $breadcrumb_class . ' li:after',
					[
						'content' => "'{$separator}'",
					]
				);
			}

			printf( '<ul class="breadcrumb %2$s">%1$s</ul>', bcn_display_list( true ), $breadcrumb_class );

			++$index_counter;
		}
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Breadcrumb::class );
