<?php
/**
 * Mobile Menu element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Menu_Mobile extends Legacy_Header_Menu {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_menu_mobile';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Menu';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_map(
			function ( $attribute ) {
				if ( 'menu_id' === $attribute->get_name() ) {
					$attribute->choices = array_map(
						function ( $choice ) {
							if ( 'main-menu' === $choice['value'] ) {
									return [
										'value' => 'mobile-menu',
										'label' => 'Mobile Menu',
									];
							}

							return $choice;
						},
						$attribute->choices
					);
				}

				return $attribute;
			},
			Attribute::flatten_attributes( parent::create_attributes() )
		);
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		// Remove standard menu class
		$classes = array_diff(
			parent::get_dom_class(),
			[
				'header-block__item--standard-menu',
			]
		);

		return array_merge(
			$classes,
			[
				'header-block__item--mobile-menu',
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Menu_Mobile::class );
