<?php
/**
 * Search Input element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Search_Input extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_search_input';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Search Field';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'search';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'placeholder',
							[
								'type'         => 'text',
								'title'        => 'Placeholder',
								'inline_label' => true,
								'placeholder'  => 'Search site...',
							]
						),
						Attribute::create(
							'max_width',
							[
								'type'        => 'range',
								'title'       => 'Max Width',
								'reset'       => true,
								'units'       => kalium_get_default_units( [ '%' ] ),
								'min'         => 30,
								'max'         => 100,
								'placeholder' => 'auto',
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		$args = [];

		// Placeholder
		if ( $placeholder = $this->get_attribute_value( 'placeholder' ) ) {
			$args['placeholder'] = $placeholder;
		}

		kalium_simple_search_form( $args );
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {
		parent::generate_styles();

		$this->add_style(
			[
				'&' => [
					'width' => $this->get_attribute( 'max_width' ),
				],
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Search_Input::class );
