<?php
/**
 * WooCommerce Product Price element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Element;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Visibility_Hover_Set;
use Laborator_Builder\Attribute_Sets\Product_Common_Attributes_Set;

class WooCommerce_Product_Price extends Element {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'woocommerce_product_price';

	/**
	 * Title.
	 *
	 * @var string
	 */
	public static $title = 'Price';

	/**
	 * Icon.
	 *
	 * @var string
	 */
	public static $icon = 'currencyDollar';

	/**
	 * Maximum instances of element.
	 *
	 * @var int
	 * @static
	 */
	public static $max_instances = 1;

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Advanced_Layout_Set::class,
				Advanced_Visibility_Hover_Set::class,
				Advanced_Border_Set::class,
				Advanced_Text_Set::class,
				Advanced_Dimensions_Set::class,
				Advanced_Custom_CSS_Set::class,
				Product_Common_Attributes_Set::class,
			]
		);
	}

	/**
	 * Check element visibility.
	 *
	 * @return bool
	 */
	public function is_visible() {
		// Catalog mode
		if ( kalium_woocommerce_catalog_mode_hide_prices() ) {
			return false;
		}

		return parent::is_visible();
	}
}

// Register element
\Laborator_Builder::register_element_type( WooCommerce_Product_Price::class );
