<?php
/**
 * Swap on hover element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Element;
use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Visibility_Hover_Set;
use Laborator_Builder\Attribute_Sets\Product_Common_Attributes_Set;

class WooCommerce_Product_Swap_On_Hover extends Element {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'woocommerce_product_swap_on_hover';

	/**
	 * Title.
	 *
	 * @var string
	 */
	public static $title = 'Swap on Hover';

	/**
	 * Icon.
	 *
	 * @var string
	 */
	public static $icon = 'replace';

	/**
	 * Child container.
	 *
	 * @var bool
	 */
	public static $child_container = true;

	/**
	 * Allowed child elements.
	 *
	 * @var array
	 */
	public static $allowed_child_elements = [
		'woocommerce_product_title',
		'woocommerce_product_category',
		'woocommerce_product_price',
		'woocommerce_product_add_to_cart',
		'woocommerce_product_attribute',
	];

	/**
	 * Maximum elements that can be added.
	 *
	 * @var int
	 * @static
	 */
	public static $max_elements = 2;

	/**
	 * Unique elements only.
	 *
	 * @var bool
	 * @static
	 */
	public static $unique_elements = true;

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Advanced_Layout_Set::class,
				Advanced_Visibility_Hover_Set::class,
				Advanced_Border_Set::class,
				Advanced_Text_Set::class,
				Advanced_Dimensions_Set::class,
				Advanced_Custom_CSS_Set::class,
				Product_Common_Attributes_Set::class,
			]
		);
	}

	/**
	 * Init.
	 */
	public function init() {
		parent::init();

		// Class
		$this->dom_attributes['class'] = [
			'swap-on-hover',
		];

		// Fade
		if ( 'fade' === $this->get_attribute_value( 'animation_type' ) ) {
			$this->dom_attributes['class'][] = $this->get_base_class() . '--fade';
		}

		// Hover attachment
		$this->dom_attributes['data-hover-attach'] = $this->get_attribute_value( 'hover_attach' );
	}


	/**
	 * Attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::TAB_CONTENT,
					[
						Attribute::create(
							'hover_attach',
							[
								'type'              => 'select',
								'title'             => 'Swap on',
								'inline_label'      => true,
								'choices'           => [
									'product-hover' => 'Product hover',
									'element-hover' => 'Element hover',
								],
								'tooltip'           => 'Hover event attachment',
								'tooltip_placement' => 'top-end',
							]
						),
						Attribute::create(
							'animation_type',
							[
								'type'         => 'radio',
								'title'        => 'Swap animation',
								'inline_label' => true,
								'choices'      => [
									'swap' => 'Swap',
									'fade' => 'Fade',
								],
								'buttons'      => true,
							]
						),
					]
				),
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( WooCommerce_Product_Swap_On_Hover::class );
