<?php
/**
 * WooCommerce Product Wishlist element.
 */

namespace Laborator_Builder\Elements;

class WooCommerce_Product_Wishlist extends WooCommerce_Product_Add_To_Cart {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'woocommerce_product_wishlist';

	/**
	 * Title.
	 *
	 * @var string
	 */
	public static $title = 'Wishlist';

	/**
	 * Icon.
	 *
	 * @var string
	 */
	public static $icon = 'heart';

	/**
	 * Maximum instances of element.
	 *
	 * @var int
	 * @static
	 */
	public static $max_instances = 1;

	/**
	 * Check if element is enabled.
	 *
	 * @return bool
	 */
	public function is_enabled() {
		return defined( 'YITH_WCWL' );
	}

	/**
	 * Disabled message.
	 *
	 * @return string
	 */
	public function get_disabled_message() {
		return 'YITH Wishlist plugin is required to display this element.';
	}
}

// Register element
\Laborator_Builder::register_element_type( WooCommerce_Product_Wishlist::class );
