<?php
/**
 * Laborator Builder.
 *
 * Placeholder class that handles a set of attributes for an element.
 */

namespace Laborator_Builder;

abstract class Attribute_Set {

	/**
	 * Element instance.
	 *
	 * @var Element
	 */
	public $element;

	/**
	 * Constructor.
	 *
	 * @param Element $element
	 */
	public function __construct( $element ) {
		$this->element = $element;
	}

	/**
	 * Get element instance.
	 *
	 * @return Element
	 */
	public function get_element() {
		return $this->element;
	}

	/**
	 * Get attributes.
	 *
	 * @return array
	 */
	public function get_attributes() {
		return [];
	}

	/**
	 * Get DOM classes.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		return [];
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {}
}
