<?php
/**
 * Visibility attributes.
 */

namespace Laborator_Builder\Attribute_Sets;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Set;

class Content_Visibility_Set extends Attribute_Set {

	/**
	 * Get attributes.
	 *
	 * @return array
	 */
	public function get_attributes() {
		return Attribute::tab_section(
			Attribute::TAB_CONTENT,
			Attribute::SECTION_CONTENT,
			[
				Attribute::create(
					'visible_on',
					[
						'type'         => 'checkbox',
						'title'        => 'Visible On',
						'inline_label' => true,
						'choices'      => [
							'desktop' => [
								'label' => 'Desktop',
								'icon'  => 'desktop',
							],
							'tablet'  => [
								'label' => 'Tablet',
								'icon'  => 'tablet',
							],
							'mobile'  => [
								'label' => 'Mobile',
								'icon'  => 'mobile',
							],
						],
						'buttons'      => [
							'icon_size' => 20,
						],
						'default'      => [ 'desktop', 'tablet', 'mobile' ],
						'order'        => 100,
					]
				),
			]
		);
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		$element = $this->get_element();
		$classes = [];

		// Visibility
		$visible_on = $element->get_attribute_value( 'visible_on' );

		if ( is_array( $visible_on ) ) {
			$classes = array_merge( $classes, kalium_get_device_visibility_classes( $visible_on ) );
		}

		return $classes;
	}
}
