<?php
/**
 * Laborator Builder.
 *
 * @author  Laborator
 * @link    https://laborator.co
 */

namespace Laborator_Builder;

class Customize_Control extends \Kalium\Customize\Control_Types\Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'laborator-builder';

	/**
	 * Content type ID.
	 *
	 * @var string
	 */
	public $content_type_id = null;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Enqueue control related scripts/styles.
	 */
	public function enqueue() {
		laborator_builder_enqueue_library();
	}

	/**
	 * Render content.
	 */
	public function render_content() {
	}

	/**
	 * Content template.
	 */
	public function content_template_copy() {
		?>
		<# if ( data.label ) { #>
		<span class="customize-control-title">{{{ data.label }}}</span>
		<# } #>
		<# if ( data.description ) { #>
		<span class="description customize-control-description">{{{ data.description }}}</span>
		<# } #>
		<div class="customize-control-content">
			<div class="laborator-builder">
				<div class="laborator-builder__loading">
					<i class="kalium-admin-icon-refresh"></i>
				</div>
			</div>
		</div>
		<?php
	}

	/**
	 * JSON content.
	 */
	public function to_json() {
		parent::to_json();

		// Content Type
		if ( $content_type = laborator_builder_get_content_type( $this->content_type_id ) ) {
			$this->json['contentTypeData'] = $content_type->export();
		}
	}
}
