<?php
/**
 * Laborator Builder.
 *
 * Responsive value container.
 */

namespace Laborator_Builder;

use Laborator_Builder;

class Responsive_Value extends Value {

	/**
	 * Constructor.
	 *
	 * @param array|mixed $value
	 */
	public function __construct( $value = null ) {
		parent::__construct();

		// Register viewports
		foreach ( Laborator_Builder::get_responsive_viewports() as $viewport_id => $viewport ) {
			$options = [];

			// Inherit from another scope
			if ( ! empty( $viewport['inherit'] ) ) {
				$options['inherit'] = $viewport['inherit'];
			}

			// Default viewport as current scope
			if ( ! empty( $viewport['default'] ) ) {
				$current_scope = $viewport_id;
			}

			// Add responsive viewport scope
			$this->add_scope( $viewport_id, $options );
		}

		// Set current scope the default viewport
		if ( isset( $current_scope ) ) {
			$this->set_scope( $current_scope );
		}

		// Assign value
		$this->assign_value( $value );
	}

	/**
	 * Get all from value container.
	 *
	 * @return array
	 */
	public function get_all_values() {
		$value = parent::get_all_values();

		unset( $value[ self::DEFAULT_SCOPE ] );

		return $value;
	}
}
